﻿using Inet.Viewer.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// Page receiver for loading the meta data of a page only. The receiver saves the
    /// parsed ReportInfo and PageInfo instances. Loading will be stopped before reaching 
    /// any rendering data of the page.
    /// </summary>
    internal class PageMetaReceiver: IPageReceiver
    {
        /// <summary>
        /// Gets the report info or null if an error occured during loading.
        /// </summary>
        internal ReportInfo ReportInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Gets the page info or null if an error occured during loadin.
        /// </summary>
        internal PageInfo PageInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Gets the error as exception or null if the loading succeeded.
        /// </summary>
        internal Exception Error
        {
            get;
            private set;
        }

        /// <inheritdoc/>
        public bool WriteReportInfo(ReportInfo info, Data.PageLoader loader)
        {
            ReportInfo = info;
            return true;
        }

        /// <inheritdoc/>
        public bool WritePageInfo(PageInfo info, Data.PageLoader loader)
        {
            PageInfo = info;
            return false;
        }

        /// <inheritdoc/>
        public System.Drawing.Font GetEmbeddedFont(int fontID, int fontRevision)
        {
            throw new NotImplementedException();
        }

        /// <inheritdoc/>
        public void PageLoadFailure(Exception exception)
        {
            Error = exception;
        }
    }
}
